

<?php $__env->startSection('title', 'Edit Product - Quotation App'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .form-container { max-width: 900px; }
    .form-group { margin-bottom: 16px; }
    .form-group label { display: block; margin-bottom: 6px; font-weight: 500; color: #374151; font-size: 14px; }
    .form-group label span { color: #dc2626; }
    .form-control, .form-select { width: 100%; padding: 10px 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 14px; }
    .form-control:focus, .form-select:focus { outline: none; border-color: #2563eb; box-shadow: 0 0 0 3px rgba(37,99,235,0.1); }
    .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
    .btn-group { display: flex; gap: 12px; margin-top: 24px; }
    .section-title { font-size: 16px; font-weight: 600; color: #374151; margin: 24px 0 16px; padding-top: 16px; border-top: 1px solid #e5e7eb; }
    .master-info { background: #f0fdf4; padding: 12px; border-radius: 6px; border-left: 4px solid #22c55e; margin-bottom: 16px; }
    .master-info p { margin: 4px 0; font-size: 13px; color: #374151; }
    
    @media (max-width: 600px) { 
        .form-row { grid-template-columns: 1fr; }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="form-container">
    <div class="card">
        <div class="card-header">
            <h1>Edit Product</h1>
            <p style="color: #6b7280; font-size: 14px; margin: 8px 0 0 0;">Update product details and specifications</p>
        </div>
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul style="margin-left: 20px;">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('products.update', $product->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <h3 class="section-title">Master Product</h3>
                
                <div class="master-info">
                    <p><strong>Name:</strong> <?php echo e($product->master->product_name); ?></p>
                    <p><strong>Note:</strong> <?php echo e($product->master->note ?? '-'); ?></p>
                </div>

                <div class="form-group">
                    <label for="product_master_id">Product Master</label>
                    <select class="form-select" id="product_master_id" name="product_master_id" required>
                        <?php $__currentLoopData = $productMasters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $master): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($master->id); ?>" <?php echo e($product->product_master_id == $master->id ? 'selected' : ''); ?>>
                                <?php echo e($master->product_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['product_master_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><small style="color: #dc2626;"><?php echo e($message); ?></small><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <h3 class="section-title">Product Details</h3>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="product_model">Model/Variant <span>*</span></label>
                        <input type="text" class="form-control" id="product_model" name="product_model" 
                               value="<?php echo e(old('product_model', $product->product_model)); ?>" required placeholder="e.g. Model A">
                        <?php $__errorArgs = ['product_model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><small style="color: #dc2626;"><?php echo e($message); ?></small><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label for="price">Price <span>*</span></label>
                        <input type="number" step="0.01" class="form-control" id="price" name="price" 
                               value="<?php echo e(old('price', $product->price)); ?>" required placeholder="0.00">
                        <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><small style="color: #dc2626;"><?php echo e($message); ?></small><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <h3 class="section-title">Specifications</h3>
                
                <div style="background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 8px; padding: 16px; margin-bottom: 16px;">
                    <div class="spec-header" style="display: grid; grid-template-columns: 2fr 2fr 1fr 60px; gap: 12px; margin-bottom: 12px; font-weight: 600; color: #374151; font-size: 13px; padding-bottom: 12px; border-bottom: 2px solid #e5e7eb;">
                        <span>Specification Name</span>
                        <span>Value</span>
                        <span>Unit</span>
                        <span></span>
                    </div>

                    <div id="specs-container">
                        <?php $__empty_1 = true; $__currentLoopData = $allSpecs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="spec-row" style="display: grid; grid-template-columns: 2fr 2fr 1fr 60px; gap: 12px; margin-bottom: 12px; align-items: end;">
                                <div class="form-group" style="margin-bottom: 0;">
                                    <input type="text" class="form-control" name="spec_name[]" 
                                           value="<?php echo e(old('spec_name.'.$index, $spec->spec_name)); ?>" placeholder="Specification Name" style="font-size: 13px;">
                                </div>
                                <div class="form-group" style="margin-bottom: 0;">
                                    <input type="text" class="form-control" name="spec_value[]" 
                                           value="<?php echo e(old('spec_value.'.$index, $spec->spec_value)); ?>" placeholder="Value" style="font-size: 13px;">
                                </div>
                                <div class="form-group" style="margin-bottom: 0;">
                                    <input type="text" class="form-control" name="spec_unit[]" 
                                           value="<?php echo e(old('spec_unit.'.$index, $spec->spec_unit)); ?>" placeholder="Unit" style="font-size: 13px;">
                                </div>
                                <div>
                                    <button type="button" class="btn-remove" onclick="removeSpecRow(this)">Remove</button>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="spec-row" style="display: grid; grid-template-columns: 2fr 2fr 1fr 60px; gap: 12px; margin-bottom: 12px; align-items: end;">
                                <div class="form-group" style="margin-bottom: 0;">
                                    <input type="text" class="form-control" name="spec_name[]" placeholder="Specification Name" style="font-size: 13px;">
                                </div>
                                <div class="form-group" style="margin-bottom: 0;">
                                    <input type="text" class="form-control" name="spec_value[]" placeholder="Value" style="font-size: 13px;">
                                </div>
                                <div class="form-group" style="margin-bottom: 0;">
                                    <input type="text" class="form-control" name="spec_unit[]" placeholder="Unit" style="font-size: 13px;">
                                </div>
                                <div>
                                    <button type="button" class="btn-remove" onclick="removeSpecRow(this)">Remove</button>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <button type="button" class="btn-add" onclick="addSpecRow()" style="font-size: 13px; padding: 6px 12px;">+ Add Another Specification</button>
                </div>

                <div class="btn-group">
                    <button type="submit" class="btn btn-primary">Update Product</button>
                    <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function addSpecRow() {
        const container = document.getElementById('specs-container');
        const rowCount = container.querySelectorAll('.spec-row').length;
        
        const newRow = document.createElement('div');
        newRow.className = 'spec-row';
        newRow.style.cssText = 'display: grid; grid-template-columns: 2fr 2fr 1fr 60px; gap: 12px; margin-bottom: 12px; align-items: end;';
        newRow.innerHTML = `
            <div class="form-group" style="margin-bottom: 0;">
                <input type="text" class="form-control" name="spec_name[]" placeholder="Specification Name" style="font-size: 13px;">
            </div>
            <div class="form-group" style="margin-bottom: 0;">
                <input type="text" class="form-control" name="spec_value[]" placeholder="Value" style="font-size: 13px;">
            </div>
            <div class="form-group" style="margin-bottom: 0;">
                <input type="text" class="form-control" name="spec_unit[]" placeholder="Unit" style="font-size: 13px;">
            </div>
            <div>
                <button type="button" class="btn-remove" onclick="removeSpecRow(this)">Remove</button>
            </div>
        `;
        container.appendChild(newRow);
    }

    function removeSpecRow(btn) {
        btn.closest('.spec-row').remove();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\office\project_alfa\quotation-app\resources\views/products/product-edit.blade.php ENDPATH**/ ?>