

<?php $__env->startSection('title', 'Customers - Quotation App'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .customers-container {
        max-width: 1200px;
        margin: 0 auto;
    }

    .customers-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
        flex-wrap: wrap;
        gap: 16px;
    }

    .customers-header h1 {
        font-size: 28px;
        font-weight: 700;
        color: #1f2937;
        margin: 0;
    }

    .customers-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        overflow: hidden;
        padding: 24px;
    }

    .customers-table {
        width: 100%;
        border-collapse: collapse;
    }

    .customers-table thead {
      background: #f9fafb; 
      color: #374151;
    }

    .customers-table th {
        padding: 16px 12px;
        text-align: left;
        font-weight: 700;
        color: #374151;
        font-size: 13px;
        letter-spacing: 0.5px;
        text-transform: uppercase;
        border: none;
    }

    .customers-table tbody tr {
        border-bottom: 1px solid #e5e7eb;
        transition: all 0.2s ease;
    }

    .customers-table tbody tr:last-child {
        border-bottom: none;
    }

    .customers-table tbody tr:hover {
        background: #f9fafb;
    }

    .customers-table td {
        padding: 14px 12px;
        color: #6b7280;
        font-size: 14px;
    }

    .customers-table td:first-child {
        color: #1f2937;
        font-weight: 600;
        width: 50px;
    }

    .customer-name {
        color: #1f2937;
        font-weight: 600;
    }

    .gst-badge {
        display: inline-block;
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
    }

    .gst-instate {
        background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
        color: #1e40af;
        border: 1px solid #93c5fd;
    }

    .gst-outstate {
        background: linear-gradient(135deg, #fecaca 0%, #fca5a5 100%);
        color: #991b1b;
        border: 1px solid #f87171;
    }

    .action-buttons {
        display: flex;
        gap: 8px;
        align-items: center;
    }

    .btn-sm {
        padding: 7px 14px;
        font-size: 12px;
        text-decoration: none;
        border-radius: 6px;
        border: none;
        cursor: pointer;
        display: inline-block;
        font-weight: 600;
        transition: all 0.2s ease;
    }

    .btn-edit {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        color: white;
        border: none;
    }

    .btn-edit:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    }

    .btn-delete {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
        border: none;
    }

    .btn-delete:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #9ca3af;
    }

    .empty-state h3 {
        font-size: 18px;
        margin-bottom: 10px;
        color: #6b7280;
        font-weight: 600;
    }

    .empty-state p {
        font-size: 14px;
        margin: 0;
    }

    .alert {
        padding: 14px 16px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .alert-success {
        background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
        border: 1px solid #6ee7b7;
        color: #065f46;
        border-radius: 8px;
    }

    @media (max-width: 768px) {
        .customers-header {
            flex-direction: column;
            align-items: flex-start;
        }

        .customers-table {
            font-size: 12px;
        }

        .customers-table th,
        .customers-table td {
            padding: 10px 8px;
        }

        .action-buttons {
            flex-direction: column;
            gap: 6px;
        }

        .btn-sm {
            width: 100%;
            text-align: center;
            padding: 6px 10px;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="customers-container">
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            ✓ <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="customers-header">
        <h1>Customers</h1>
        <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">+ Add Customer</a>
    </div>

    <div class="customers-card">
        <?php if($customers->count() > 0): ?>
            <table class="customers-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Customer Name</th>
                        <th>City</th>
                        <th>Mobile</th>
                        <th>Email</th>
                        <th>GST No</th>
                        <th>GST Type</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td class="customer-name"><?php echo e($customer->customer_name); ?></td>
                            <td><?php echo e($customer->city ?? '-'); ?></td>
                            <td><?php echo e($customer->mobile); ?></td>
                            <td><?php echo e($customer->email ?? '-'); ?></td>
                            <td><?php echo e($customer->gst_no ?? '-'); ?></td>
                            <td>
                                <?php if($customer->gst_type == 'instate'): ?>
                                    <span class="gst-badge gst-instate">In-State (18%)</span>
                                <?php else: ?>
                                    <span class="gst-badge gst-outstate">Out-of-State (18%)</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <a href="<?php echo e(route('customers.edit', $customer)); ?>" class="btn-sm btn-edit">Edit</a>
                                    <form action="<?php echo e(route('customers.destroy', $customer)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this customer?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn-sm btn-delete">Delete</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="empty-state">
                <h3>No customers yet</h3>
                <p>Click the "Add Customer" button to add your first customer.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\office\project_alfa\quotation-app\resources\views/customers/index.blade.php ENDPATH**/ ?>